import React, { useState, useEffect } from 'react';
import { X, Save, Copy } from 'lucide-react';

export function CellModal({ isOpen, onClose, value, onSave, title }) {
    const [content, setContent] = useState(value);

    useEffect(() => {
        setContent(value);
    }, [value]);

    if (!isOpen) return null;

    return (
        <div className="fixed inset-0 bg-black/50 flex items-center justify-center z-[100]">
            <div className="bg-[var(--bg-secondary)] w-[80vw] h-[80vh] rounded-lg shadow-xl border border-[var(--border-color)] flex flex-col">
                {/* Header */}
                <div className="p-4 border-b border-[var(--border-color)] flex justify-between items-center bg-[var(--bg-tertiary)]">
                    <h2 className="text-lg font-bold font-mono text-[var(--accent-primary)]">{title || 'Cell Editor'}</h2>
                    <div className="flex gap-2">
                        <button
                            onClick={() => { navigator.clipboard.writeText(content); }}
                            className="p-2 hover:bg-[var(--bg-primary)] rounded text-[var(--text-muted)] hover:text-white"
                            title="Copy to Clipboard"
                        >
                            <Copy size={18} />
                        </button>
                        <button onClick={onClose} className="p-2 hover:bg-[var(--bg-primary)] rounded text-[var(--text-muted)] hover:text-white">
                            <X size={20} />
                        </button>
                    </div>
                </div>

                {/* Content */}
                <div className="flex-1 p-0 overflow-hidden relative">
                    <textarea
                        value={content || ''}
                        onChange={(e) => setContent(e.target.value)}
                        className="w-full h-full p-4 bg-[var(--bg-primary)] text-[var(--text-primary)] font-mono text-sm resize-none focus:outline-none"
                        placeholder="Empty cell..."
                    />
                </div>

                {/* Footer */}
                <div className="p-4 border-t border-[var(--border-color)] flex justify-end gap-2 bg-[var(--bg-tertiary)]">
                    <button onClick={onClose} className="btn">Cancel</button>
                    <button
                        onClick={() => { onSave(content); onClose(); }}
                        className="btn btn-primary"
                    >
                        <Save size={16} /> Save Changes
                    </button>
                </div>
            </div>
        </div>
    );
}
